<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProcessStepAction extends Model 
{

    protected $table = 'process_step_actions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('process_step_id', 'process_step_version', 'target', 'component', 'component_version', 'order', 'result', 'process_step_action_id');

    public function dependentActions()
    {
        return $this->hasMany('App\Models\ProcessStepAction', 'process_step_action_id');
    }

    public function parentAction()
    {
        return $this->belongsTo('App\Models\ProcessStepAction', 'process_step_action_id');
    }

    public function target()
    {
        return $this->morphTo();
    }

    public function component()
    {
        return $this->morphTo();
    }

}